///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK SQLPWDDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND MasterServer_hWnd     = NULL;
    static HWND MasterDatabase_hWnd   = NULL;
    static HWND MasterDriver_hWnd     = NULL;
    static HWND MasterUID_hWnd        = NULL;
    static HWND MasterPWS_hWnd        = NULL;


    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        SQLPWDDialog_hWnd = xHandle;

        SPWD.Dialog_hWnd = SQLPWDDialog_hWnd;

        SendMessage(SQLPWDDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"SQL Password");
        SendMessage(SQLPWDDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(DialogIcon)) );

        MasterServer_hWnd     = GetDlgItem(SQLPWDDialog_hWnd, 1000);
        MasterDatabase_hWnd   = GetDlgItem(SQLPWDDialog_hWnd, 1001);
        MasterDriver_hWnd     = GetDlgItem(SQLPWDDialog_hWnd, 1002);
        MasterUID_hWnd        = GetDlgItem(SQLPWDDialog_hWnd, 2000);
        MasterPWS_hWnd        = GetDlgItem(SQLPWDDialog_hWnd, 2001);

        Set_Text(MasterServer_hWnd, MasterServer);
        Set_Text(MasterDatabase_hWnd, MasterDatabase);
        Set_Text(MasterDriver_hWnd, MasterDriver);
        Set_Text(MasterUID_hWnd, MasterUID);
        Set_Text(MasterPWS_hWnd, MasterPWS);

        if(MasterTrusted)
            CheckDlgButton(SQLPWDDialog_hWnd, 3000, BST_CHECKED);

        if(SavePassword)
            CheckDlgButton(SQLPWDDialog_hWnd, 3001, BST_CHECKED);

        CenterWindow(SQLPWDDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {

            Get_TextEx(MasterServer_hWnd,   MasterServer,   256);
            Get_TextEx(MasterDatabase_hWnd, MasterDatabase, 256);
            Get_TextEx(MasterDriver_hWnd,   MasterDriver,   256);
            Get_TextEx(MasterUID_hWnd,      MasterUID,      256);
            Get_TextEx(MasterPWS_hWnd,      MasterPWS,      256);

            if(IsDlgButtonChecked(SQLPWDDialog_hWnd, 3000))
                MasterTrusted = TRUE;
            else MasterTrusted = FALSE;

            if(IsDlgButtonChecked(SQLPWDDialog_hWnd, 3001))
                SavePassword = TRUE;
            else SavePassword = FALSE;

            EndDialog(SQLPWDDialog_hWnd,0);
            DestroyWindow(SQLPWDDialog_hWnd);

            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            SPWD.Cancel = TRUE;
            EndDialog(SQLPWDDialog_hWnd,0);
            DestroyWindow(SQLPWDDialog_hWnd);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(SQLPWDDialog_hWnd,0);
        DestroyWindow(SQLPWDDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

